
// BIURLReference.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.

/*!
    @class       BIURLReference
    @abstract    BIURLReference represents an alias to a file or a http address.
    @discussion  Files use aliases, so we are actually storing an alias in the database and not the file itself.  Therefore, if the user moves the file on the system, we will still be able to resolve where the file is.
*/


#ifdef BILLINGS_PRO
#import "_BPURLReference.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIURLReference.h"
#endif
#import "BIAppVersioning.h"


enum {
	BIURL_FILETYPE = 1,
	BIURL_HTTPTYPE = 2,
	BIURL_MAILTYPE = 3
};

@interface BIURLReference : BL_SUPER_CLASSNAME_MUNGE(URLReference) 
{
}

- (NSString*)fileKind;
- (void)setFileKind:(NSString*)aKind;

- (NSString*)MCKindFromPath:(NSString*)path;

- (void)setIsFileType:(BOOL)aFlag;
- (BOOL)isFileType;
- (void)setIsHTTPType:(BOOL)aFlag;
- (BOOL)isHTTPType;
- (void)setIsMailType:(BOOL)aFlag;
- (BOOL)isMailType;

- (void)setUrlWrapper:(id)aWrap;
- (id)urlWrapper;

- (NSString*)urlDisplayString;
- (void)setUrlDisplayString:(NSString*)aString;

- (NSString*)urlFullPathString;
- (void)setUrlFullPathString:(NSString*)aString;

- (NSString*)kindWrapper;
- (void)setKindWrapper:(NSString*)aString;

- (BOOL)nameIsEditable;

- (BOOL)isFileLocalyAvailable;

#ifdef BILLINGS_PRO
+ (NSString *)fullStoragePathForRelativePath:(NSString *)aStub;
+ (NSString *)relativeStoragePathForFullPath:(NSString *)full;

- (BOOL)hasEmbeddedStorage;
- (void)storeData:(NSData *)someData;

// called from the migrator only!
- (void)migrateIntoEmbeddedFileStorageUsingBasePath:(NSString *)aPath;
- (void)copyToBillingsProFolder:(NSString *)aFolder cloudUploadFolder:(NSString *)uploadFolder databaseUUID:(NSString *)uuid basePath:(NSString *)aPath error:(NSError **)error;
- (void)changeURLWrapperFromAliasToPathError:(NSError **)error;

- (NSString *)originalBillings3FilePath;

#endif

@end
